import {ItemLockMode, ItemStack, system, world} from "@minecraft/server";
import { ConstantData } from "../ConstantData";
import { db } from "../main";
import { CommandJ } from "../Database/Command";
import { Human } from "../Game/Structure/Human";
import { report } from "./ConstantLoader";

/**
 * Loads a player's data when they join the world. New Players get a new Human object and every Player is teleported to their supposed spawn.
 */
export function loadPlayerData(){
    world.afterEvents.playerSpawn.subscribe((ev)=>{
        if(!db.getInTable("userData", "players").includes(ev.player.id)){
            let menu = new ItemStack("jo:menu", 1); menu.keepOnDeath=true; menu.lockMode = ItemLockMode.inventory; menu.setLore(["Interact with it to open the main menu."]);
            ev.player.getComponent("inventory").container.setItem(8, menu);
            db.getInTable("userData", "players").push(ev.player.id);
            let humanObj = new Human(ev.player.name, ev.player.name, Date(), "none");
            db.getInTable("userData", "humanObjects").push(humanObj);
            world.sendMessage("A new Human has entered this world! \nWelcome "+ev.player.name+"\nId: "+ev.player.id);
        };
    });
};
/**
 * Turns the Database's human data into Human objects
 */
export function loadHumanObjects(){
    for(let h = 0; h < db.getInTable("userData", "humanObjects").length; h++){
        let human = Human.newHumanFromString(JSON.stringify(db.getInTable("userData", "humanObjects")[h]));
        let obj = db.getInTable("userData", "humanObjects"); obj[h] = human;
    };
};
/**
 * Loads the Database's data when loading the world
 * @returns {void}
 */
export function getDatabaseDataInitial(){
    if(!world.getDynamicProperty("jo_data:database")){
        return;
    }else {
        db.loadFromPropertyIds(world, "jo_data:database");
        report("Database: "+world.getDynamicProperty("jo_data:database"));
    };
};
/**
 * Saves the Database data when the last player leaves
 */
export function saveDatabaseDataTerminal(){
    world.beforeEvents.playerLeave.subscribe((ev)=>{
        if(world.getAllPlayers().length==1){
            report(db.getSaveString());
            db.saveDatabase("jo_data:database", world);
        }else {
            return;
        }
    });
};
/**
 * Registers custom commands that can be ran using '-run'
 */
export function registerCommands(){
    let helpCommand = new CommandJ("jo:helpC", "Tells the player all command Ids", (player)=>{let commandList = []; for(let c = 0; c<CommandJ.storage.length; c++){commandList.push(CommandJ.storage[c].id)}; player.sendMessage("=== List of Command Identifiers ===\n"+commandList.join(", ")+"\n===")}, []);
    helpCommand.registerCommand();
    let databaseCommand = new CommandJ("jo:databaseC", "Gives the player the current Database", (player)=>{player.sendMessage("Database Status: "+db.getSaveString())}, []);
    databaseCommand.registerCommand();
    let registerCommand = new CommandJ("jo:registerC", "Registerrs the player manually", (player)=>{if(!db.getInTable("userData", "players").includes(player.id)){
        let menu = new ItemStack("jo:menu", 1); menu.keepOnDeath=true; menu.lockMode = ItemLockMode.inventory; menu.setLore(["Interact with it to open the main menu."]);
        player.getComponent("inventory").container.setItem(8, menu);
        db.getInTable("userData", "players").push(player.id);
        let humanObj = new Human(player.name, player.name, Date(), "none");
        db.getInTable("userData", "humanObjects").push(humanObj);
        world.sendMessage("A new Human has entered this world! \nWelcome "+player.name);
        player.teleport(ConstantData.initialSpawnPoint);
    };
    if(player.isOp()){
        player.teleport(ConstantData.adminSpawnPoint);
    }else {
        player.teleport(ConstantData.userSpawnPoint);
    };}, []);
    registerCommand.registerCommand();
    let timeCommand = new CommandJ("jo:timeC", "Tells a Player the time", (player)=>{player.sendMessage("Time:"+world.getTimeOfDay()); return;}, []);
    timeCommand.registerCommand();
    let propertyCommand = new CommandJ("jo:propertyC", "Allows the player to change it's properties", (player, additional)=>{if(additional[2]=="bool"){player.setProperty(additional[0], additional[1]=="true")}else if(additional[2]=="int"){player.setProperty(additional[0], Number.parseInt(additional[1]))}else if(additional=="string"){player.setProperty(additional[0], additional[1])};player.sendMessage(player.getProperty(additional[0]).toString()+" is") }, ["property", "value", "type"]);
    propertyCommand.registerCommand();
    let saveCommand = new CommandJ("jo:saveDataC", "Saves the database and sends the database's size", (player)=>{db.saveDatabase("jo_data:database", world); player.sendMessage("Database content: "+db.getSaveString()); player.sendMessage("Dynamic size: "+ world.getDynamicPropertyTotalByteCount())}, []);
    saveCommand.registerCommand();
};